
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_Authenticators.c#1:csrc:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include "SST_Ext_ATP_Authenticators.h"
#include "SST_Ext_ATP_AuthenticatorsTstVectors.h"
#include "MW_ATP_UTIL_funcs.h"
#include "ExtApp_HOST_TST_Message.h"
#if TST_USE_AUTHENTICATOR_MODULE
/************************ Defines ******************************/
#define TESTPASS 	                     0
#define TESTFAIL 	                     1
#define TST_FUNC_STRING_LEN 100
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
DxError_t      EXT_TST_ATP_Error;
DxUint8_t      EXT_FailureFunctionNameOut[TST_FUNC_STRING_LEN];
DxError_t      EXT_TST_TestStatus;
DxError_t      EXT_TST_Error;

/************************ Public Functions *********************/
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_PasswordAuthenticator         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the creation, deletion, modification, opening, 
 * closing and usage of a password authenticator object. 
 * And demonstrate the use of transaction with authenticator objects
 *  
 * Algorithm:       
 *    1.Call to HOSTQA_ATP_Message function
 *                                
 *******************************************************************************/    
DxError_t SST_Ext_ATP_PasswordAuthenticator ()
{
    /********* TST Variables Definitions ************/
    
    int                         TST_index =0;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_PasswordAuthenticator";
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    
	ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",SEP_ATP_PassAuthObjectTestData[TST_index].TST_Name,"\n"));

    EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_SST_PasAuthenticator_OP_CODE,
                                           sizeof(SEP_ATP_PassAuthTestDataStruct),
                                           SEP_ATP_PassAuthObjectTestData);
  
    EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SEPQA_ATP_PasswordAuthenticator", 
		                                          "HOSTQA_ATP_Message",TST_MasterTestName); 
      
    return EXT_TST_TestStatus;
}/* End of SST_TST_ATP_PasswordAuthenticator */

/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_RsaAsymAuthenticator         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the creation, deletion, modification, opening, closing and usage of an asymmetric key authenticator object.
 * And demonstration on the use of transaction with authenticator objects.
 *  
 * Algorithm:       
 *    1.Call to HOSTQA_ATP_Message function                         
 *
 *******************************************************************************/    
DxError_t SST_Ext_ATP_RsaAsymAuthenticator ()
{
    /********* TST Variables Definitions ************/
    int                         TST_index = 0;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_RsaAsymAuthenticator";    
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",SEP_ATP_PassAuthObjectTestData[TST_index].TST_Name,"\n"));

    EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_SST_RsaAsymAuthenticator_OP_CODE,
                                           sizeof(EXT_ATP_RsaAuthTestDataStruct),
                                           SEP_ATP_RsaAuthObjectTestData);

	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SEPQA_ATP_RsaAsymAuthenticator", 
											      "HOSTQA_ATP_Message",TST_MasterTestName); 
    return EXT_TST_TestStatus;
}/* End of SST_TST_ATP_RsaAsymAuthenticator */

/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_AesKeyAsymAuthenticator         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the creation, deletion, modification, opening, closing and usage of a shared key authenticator object.
 * And demonstration on the use of transaction with authenticator objects
 *  
 * Algorithm:       
 *   1.Call to HOSTQA_ATP_Message function
 * 
 *******************************************************************************/    
DxError_t SST_Ext_ATP_AesKeyAsymAuthenticator ( )
{
    /********* TST Variables Definitions ************/
    int                         TST_index = 0;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_AesKeyAsymAuthenticator";
    
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;
   
    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

  
    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",SEP_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,"\n"));

    EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_SST_AesKeyAsymAuthenticator_OP_CODE,
                                           sizeof(EXT_ATP_AesKeyAuthTestDataStruct),
                                           SEP_ATP_AesKeyAuthObjectTestData);

	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error, "SEPQA_ATP_AesKeyAsymAuthenticator", 
											  "HOSTQA_ATP_Message", TST_MasterTestName); 
    return EXT_TST_TestStatus;
}/* End of SST_TST_ATP_AesKeyAsymAuthenticator */
/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_ECCAsymAuthenticator         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the creation, deletion, modification, opening, closing and usage of an ECC asymmetric key authenticator object.
 * And demonstration on the use of transaction with authenticator objects.
 *  
 * Algorithm:       
 *   1.Call to SEPQA_ATP_AesKeyAsymAuthenticator function
 * 
 *******************************************************************************/    
DxError_t SST_Ext_ATP_ECCAsymAuthenticator ()
{
    /********* TST Variables Definitions ************/
    int                         TST_index = 0;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_ECCAsymAuthenticator";
    
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;
    
    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",SEP_ATP_ECCAuthObjectTestData[TST_index].TST_Name,"\n"));
                   
    EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_SST_ECCAsymAuthenticator_OP_CODE,
                                           sizeof(EXT_ATP_ECCAuthTestDataStruct),
                                           SEP_ATP_ECCAuthObjectTestData);

	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error, "SEPQA_ATP_ECCAsymAuthenticator", 
											 "HOSTQA_ATP_Message", TST_MasterTestName); 
    return EXT_TST_TestStatus;
}/* End of SST_TST_ATP_ECCAsymAuthenticator */
/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/

#endif

